#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ReagentType : BaseTest 
	{

		private DataTable _dtReagentTypeParameter;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//Create data just in case
				int reagentTypeId = new Random().Next(11,31);
				short minLevel = (short)new Random().Next(1,99);
				DAL.ReagentType.InsertReagent(reagentTypeId, minLevel, Common.UpdateFunction.UnitTests);

				this._dtReagentTypeParameter = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ReagentTypeParameter WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetReagentTypes_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetReagentTypes();

			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.SortColumn), TABLES.ReagentType.SortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReagentTypes_Fail()
		{
		}

		[Test]
		public void GetAntigenTypingTests_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetAntigenTypingTests();

			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTypingTests_Fail()
		{
		}

		[Test]
		public void GetAntigenTypingReagentTypes_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetAntigenTypingReagentTypes();

			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestName), TABLES.OrderableTest.OrderableTestName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTypingReagentTypes_Fail()
		{
		}

		[Test]
		public void GetAntigenTypingQCReagentTypes_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetAntigenTypingQCReagentTypes();

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTypingQCReagentTypes_Fail()
		{
		}
		
		[Test]
		public void GetExistingMinimumLevels_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetExistingMinimumLevels(UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(4, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTypeParameter.ReagentTypeParameterGuid), TABLES.ReagentTypeParameter.ReagentTypeParameterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTypeParameter.ReagentTypeId), TABLES.ReagentTypeParameter.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTypeParameter.MinimumStockLevel), TABLES.ReagentTypeParameter.MinimumStockLevel);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTypeParameter.RowVersion), TABLES.ReagentTypeParameter.RowVersion);
		}

		[Test]
		public void GetExistingMinimumLevels_Fail()
		{
			DataTable dtTest = DAL.ReagentType.GetExistingMinimumLevels(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetDailyQCReagentTypes_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetDailyQCReagentTypes(UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(12, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.MustUseIndicator), TABLES.ReagentType.MustUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.CanChangeIndicator), TABLES.ReagentTestParameter.CanChangeIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.TestWithName), TABLES.ReagentTestParameter.TestWithName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.TestWithId), TABLES.ReagentTestParameter.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ExpectedMinimumReactions), TABLES.ReagentTestParameter.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.SetVialId), TABLES.ReagentTestParameter.SetVialId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReactivityPhaseCode), TABLES.ReagentTestParameter.ReactivityPhaseCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyControl.PrimaryEnhancementMediaId), TABLES.DailyControl.PrimaryEnhancementMediaId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DailyControl.SecondaryEnhancementMediaId), TABLES.DailyControl.SecondaryEnhancementMediaId);
		}

		[Test]
		public void GetDailyQCReagentTypes_Fail()
		{
			DataTable dtTest = DAL.ReagentType.GetDailyQCReagentTypes(string.Empty);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetDailyQCReagentTypesForPartiallyCompletedQc_Pass()
		{
			System.Guid worklistGuid = DataCreator.GetRecordGuid("SELECT TOP 1 DailyQcWorklistGuid FROM DailyQcWorklist WHERE RecordStatusCode = 'A' AND DivisionCode = '" + this.TestDivisionCode + "'");
			DataTable dtTest = DAL.ReagentType.GetDailyQCReagentTypesForPartiallyCompletedQc(worklistGuid);

			Assert.AreEqual(16, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeId), TABLES.ReagentType.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.ReagentTypeName), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentType.MustUseIndicator), TABLES.ReagentType.MustUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.TestWithName), TABLES.ReagentTestParameter.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.TestWithId), TABLES.ReagentTestParameter.TestWithId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ExpectedMinimumReactions), TABLES.ReagentTestParameter.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.SetVialId), TABLES.ReagentTestParameter.SetVialId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentGuid), TABLES.Reagent.ReagentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotExpirationDate), TABLES.Reagent.LotExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.LotNumber), TABLES.Reagent.LotNumber);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.ReagentManufacturerName), TABLES.Reagent.ReagentManufacturerName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Reagent.InspectionIndicator), TABLES.Reagent.InspectionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RackLot.TestingMethodCode), TABLES.RackLot.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseText), TABLES.ReactivityPhase.ReactivityPhaseText);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseCode), TABLES.ReactivityPhase.ReactivityPhaseCode);
		}

		[Test]
		public void GetDailyQCReagentTypesForPartiallyCompletedQc_Fail()
		{
			DataTable dtTest = DAL.ReagentType.GetDailyQCReagentTypesForPartiallyCompletedQc(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEmptyReagentTestParameterTableSchema_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetEmptyReagentTestParameterTableSchema(true);

			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.ReagentTestParameterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTypeId), TABLES.ReagentTestParameter.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.CommercialIndicator), TABLES.ReagentTestParameter.CommercialIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.MustUseIndicator), TABLES.ReagentTestParameter.MustUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.CanChangeIndicator), TABLES.ReagentTestParameter.CanChangeIndicator);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.DailyUseIndicator), TABLES.ReagentTestParameter.DailyUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.TestWithName), TABLES.ReagentTestParameter.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.TestWithId), TABLES.ReagentTestParameter.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.SetVialId), TABLES.ReagentTestParameter.SetVialId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReactivityPhaseCode), TABLES.ReagentTestParameter.ReactivityPhaseCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ExpectedMinimumReactions), TABLES.ReagentTestParameter.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.DivisionCode), TABLES.ReagentTestParameter.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.RecordStatusCode), TABLES.ReagentTestParameter.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.SortColumn), TABLES.ReagentTestParameter.SortColumn);
		}

		[Test]
		public void GetEmptyReagentTestParameterTableSchema_Fail()
		{
			DataTable dtTest = DAL.ReagentType.GetEmptyReagentTestParameterTableSchema(true);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}


		[Test]
		public void GetReagentQCData_Pass()
		{
			DataTable dtTest = DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, true);
			DataTable dtTest2 = DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, false);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(true, dtTest.Columns.Count == 17, "Columns.Count");
			Assert.AreEqual(dtTest.Columns.Count, dtTest2.Columns.Count, "Cols[1] = Cols[2]");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.ReagentTestParameterGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.ReagentTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.CommercialIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.MustUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.CanChangeIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.DailyUseIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.TestWithName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.TestWithId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.SetVialId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReactivityPhase.ReactivityPhaseCode), TABLES.ReactivityPhase.ReactivityPhaseCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.ExpectedMinimumReactions);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentTestParameter.RecordStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.ReagentType.ReagentTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ReagentTestParameter.ReagentTestParameterGuid), TABLES.TestResult.TestResultText);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReagentQCData_Fail()
		{
			DataTable dtTest = DAL.ReagentType.GetReagentQCData(string.Empty, true);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetCanChangeExpectedMinReactions_Pass()
		{
			System.Collections.ArrayList alTest = DAL.ReagentType.GetCanChangeExpectedMinReactions();

			Assert.AreEqual(true, alTest.Count > 0, "Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCanChangeExpectedMinReactions_Fail()
		{
		}

		[Test]
		public void SaveReagentStockLevels_Pass()
		{
			this.RefreshData = true;

			Guid reagentTypeParameterGuid = (Guid)(this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.ReagentTypeParameterGuid]);
			int minLevel = System.Convert.ToInt32(this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.MinimumStockLevel]);
			byte[] rowVersion = (byte[])this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.RowVersion];

			DAL.ReagentType.SaveReagentStockLevels(reagentTypeParameterGuid, minLevel, Common.LogonUser.LogonUserName, rowVersion, Common.UpdateFunction.UnitTests);

			Assert.IsTrue(true, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void SaveReagentStockLevels_Fail()
		{
			Guid reagentTypeParameterGuid = (Guid)(this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.ReagentTypeParameterGuid]);
			int minLevel = System.Convert.ToInt32(this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.MinimumStockLevel]);
			byte[] rowVersion = new byte[8];

			DAL.ReagentType.SaveReagentStockLevels(reagentTypeParameterGuid, minLevel, Common.LogonUser.LogonUserName, rowVersion, Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void InsertReagent_Pass()
		{
			int reagentTypeId = System.Convert.ToInt32(this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.ReagentTypeId]);
			
			DAL.ReagentType.InsertReagent(reagentTypeId, 99, Common.UpdateFunction.UnitTests);

			Assert.IsTrue(true, "RetunValue");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void InsertReagent_Fail()
		{
			int reagentTypeId = System.Convert.ToInt32(this._dtReagentTypeParameter.Rows[0][TABLES.ReagentTypeParameter.ReagentTypeId]);

			DAL.ReagentType.InsertReagent(0, 99, Common.UpdateFunction.UnitTests);
		}

	}
}
#endif
